/**
 * \file
 *
 * \brief USB configuration file for CDC application
 *
 * Copyright (c) 2009-2014 Atmel Corporation. All rights reserved.
 *
 * \asf_license_start
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 *    Atmel microcontroller product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * \asf_license_stop
 *
 */

#ifndef _CONF_USB_H_
#define _CONF_USB_H_

#include "compiler.h"
#include "board.h"

/**
 * USB Device Configuration
 * @{
 */

 // Arduino srl USB VID Definition.
 #define USB_VENDOR_ID						0x2A03
 #define USB_VENDOR_DESCRIPTOR				"Arduino srl (www.arduino.org)"
 
 // Arduiino Zero Pro USB PID
 //#define USB_PRODUCT_ID						0x004D
 //#define USB_PRODUCT_NAME					"Arduino Zero PRO"
 
 // Arduino M0 Pro USB PID
 //#define USB_PRODUCT_ID						0x004E		// Arduino M0 PID
 //#define USB_PRODUCT_NAME					"Arduino M0 PRO"
 
 // Arduino M0 Pro USB PID
 //#define USB_PRODUCT_ID						0x004F		// Arduino M0 PRO PID
 //#define USB_PRODUCT_NAME					"Arduino M0 PRO"
 
 // Arduino Tian USB PID
 #define USB_PRODUCT_ID						0x0052		// Arduino Tian PID
 #define USB_PRODUCT_NAME					"Arduino Tian"
 
 // Arduino M0s USB PID
 //#define USB_PRODUCT_ID						0x0053		// Arduino M0s PID
 //#define USB_PRODUCT_NAME					"Arduino M0s"



//! Device definition (mandatory)
#define  USB_DEVICE_VENDOR_ID				USB_VENDOR_ID
#if BOARD == UC3B_BOARD_CONTROLLER
# define  USB_DEVICE_PRODUCT_ID				USB_PID_ATMEL_UC3_CDC_DEBUG
#else
# define  USB_DEVICE_PRODUCT_ID				USB_PRODUCT_ID


#endif
#define  USB_DEVICE_MAJOR_VERSION         1
#define  USB_DEVICE_MINOR_VERSION         0
#define  USB_DEVICE_POWER                 100 // Consumption on Vbus line (mA)
#define  USB_DEVICE_ATTR                  \
	(USB_CONFIG_ATTR_SELF_POWERED)
// (USB_CONFIG_ATTR_BUS_POWERED)
//	(USB_CONFIG_ATTR_REMOTE_WAKEUP|USB_CONFIG_ATTR_SELF_POWERED)
//	(USB_CONFIG_ATTR_REMOTE_WAKEUP|USB_CONFIG_ATTR_BUS_POWERED)

//! USB Device string definitions (Optional)
#define  USB_DEVICE_MANUFACTURE_NAME     USB_VENDOR_DESCRIPTOR
#define  USB_DEVICE_PRODUCT_NAME         USB_PRODUCT_NAME

// Serial Number Definition (needed for Drivers Signature)
//#define  USB_DEVICE_SERIAL_NAME           "004D"			// Arduino Zero PRO USB Serial Number
//#define  USB_DEVICE_SERIAL_NAME           "004F"			// Arduino M0 PRO USB Serial Number
//#define  USB_DEVICE_SERIAL_NAME           "004E"			// Arduino M0 USB Serial Number
//#define  USB_DEVICE_SERIAL_NAME           "0052"			// Arduino Tian Serial Number
#define  USB_DEVICE_SERIAL_NAME           "0053"			// Arduino M0s Serial Number





/**
 * Device speeds support
 * Low speed not supported by CDC
 * @{
 */
//! To authorize the High speed
#if (UC3A3||UC3A4)
#define  USB_DEVICE_HS_SUPPORT
#elif (SAM3XA||SAM3U)
#define  USB_DEVICE_HS_SUPPORT
#endif
//@}


/**
 * USB Device Callbacks definitions (Optional)
 * @{
 */
#define  UDC_VBUS_EVENT(b_vbus_high)
#define  UDC_SOF_EVENT()                  
#define  UDC_SUSPEND_EVENT()              
#define  UDC_RESUME_EVENT()               
//! Mandatory when USB_DEVICE_ATTR authorizes remote wakeup feature
// #define  UDC_REMOTEWAKEUP_ENABLE()        user_callback_remotewakeup_enable()
// extern void user_callback_remotewakeup_enable(void);
// #define  UDC_REMOTEWAKEUP_DISABLE()       user_callback_remotewakeup_disable()
// extern void user_callback_remotewakeup_disable(void);
#ifdef USB_DEVICE_LPM_SUPPORT
#define  UDC_SUSPEND_LPM_EVENT()          
#define  UDC_REMOTEWAKEUP_LPM_ENABLE()    
#define  UDC_REMOTEWAKEUP_LPM_DISABLE()  
#endif
//! When a extra string descriptor must be supported
//! other than manufacturer, product and serial string
// #define  UDC_GET_EXTRA_STRING()
//@}

//@}


/**
 * USB Interface Configuration
 * @{
 */
/**
 * Configuration of CDC interface
 * @{
 */

//! Define two USB communication ports
#define  UDI_CDC_PORT_NB 1

//! Interface callback definition
#define  UDI_CDC_ENABLE_EXT(port) true
#define  UDI_CDC_DISABLE_EXT(port)
#define  UDI_CDC_RX_NOTIFY(port)          
#define  UDI_CDC_TX_EMPTY_NOTIFY(port)
#define  UDI_CDC_SET_CODING_EXT(port,cfg) main_cdc_config(port,cfg)
#define  UDI_CDC_SET_DTR_EXT(port,set)
#define  UDI_CDC_SET_RTS_EXT(port,set)

//! Define it when the transfer CDC Device to Host is a low rate (<512000 bauds)
//! to reduce CDC buffers size
//#define  UDI_CDC_LOW_RATE

//! Default configuration of communication port
#if BOARD == UC3B_BOARD_CONTROLLER
#define  UDI_CDC_DEFAULT_RATE             57600
#else
#define  UDI_CDC_DEFAULT_RATE             115200
#endif
#define  UDI_CDC_DEFAULT_STOPBITS         CDC_STOP_BITS_1
#define  UDI_CDC_DEFAULT_PARITY           CDC_PAR_NONE
#define  UDI_CDC_DEFAULT_DATABITS         8
//@}
//@}


/**
 * USB Device Driver Configuration
 * @{
 */
//@}

//! The includes of classes and other headers must be done at the end of this file to avoid compile error
#include "udi_cdc_conf.h"
#include "main.h"

#endif // _CONF_USB_H_
