/**
 * \file
 *
 * \brief SAM USART Quick Start
 *
 * Copyright (C) 2012-2014 Atmel Corporation. All rights reserved.
 *
 * \asf_license_start
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 *    Atmel microcontroller product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * \asf_license_stop
 *
 */

/**
 * \page asfdoc_sam0_sercom_usart_basic_use_case Quick Start Guide for SERCOM USART - Basic
 *
 * This quick start will echo back characters typed into the terminal. In this
 * use case the USART will be configured with the following settings:
 * - Asynchronous mode
 * - 9600 Baudrate
 * - 8-bits, No Parity and 1 Stop Bit
 * - TX and RX enabled and connected to the Xplained Pro Embedded Debugger virtual COM port
 *
 * \section asfdoc_sam0_sercom_usart_basic_use_case_setup Setup
 *
 * \subsection asfdoc_sam0_sercom_usart_basic_use_case_prereq Prerequisites
 * There are no special setup requirements for this use-case.
 *
 * \subsection asfdoc_sam0_usart_basic_use_case_setup_code Code
 * Add to the main application source file, outside of any functions:
 * \snippet qs_usart_basic_use.c module_inst
 *
 * Copy-paste the following setup code to your user application:
 * \snippet qs_usart_basic_use.c setup
 *
 * Add to user application initialization (typically the start of \c main()):
 * \snippet qs_usart_basic_use.c setup_init
 *
 * \subsection asfdoc_sam0_usart_basic_use_case_setup_flow Workflow
 * -# Create a module software instance structure for the USART module to store
 *    the USART driver state while it is in use.
 *    \snippet qs_usart_basic_use.c module_inst
 *    \note This should never go out of scope as long as the module is in use.
 *          In most cases, this should be global.
 *
 * -# Configure the USART module.
 *  -# Create a USART module configuration struct, which can be filled out to
 *     adjust the configuration of a physical USART peripheral.
 *     \snippet qs_usart_basic_use.c setup_config
 *  -# Initialize the USART configuration struct with the module's default values.
 *     \snippet qs_usart_basic_use.c setup_config_defaults
 *     \note This should always be performed before using the configuration
 *           struct to ensure that all values are initialized to known default
 *           settings.
 *
 *  -# Alter the USART settings to configure the physical pinout, baud rate and
 *     other relevant parameters.
 *     \snippet qs_usart_basic_use.c setup_change_config
 *  -# Configure the USART module with the desired settings, retrying while the
 *     driver is busy until the configuration is stressfully set.
 *     \snippet qs_usart_basic_use.c setup_set_config
 *  -# Enable the USART module.
 *     \snippet qs_usart_basic_use.c setup_enable
 *
 *
 * \section asfdoc_sam0_usart_basic_use_case_main Use Case
 *
 * \subsection asfdoc_sam0_usart_basic_use_case_main_code Code
 * Copy-paste the following code to your user application:
 * \snippet qs_usart_basic_use.c main
 *
 * \subsection asfdoc_sam0_usart_basic_use_case_main_flow Workflow
 * -# Send a string to the USART to show the demo is running, blocking until
 *    all characters have been sent.
 *    \snippet qs_usart_basic_use.c main_send_string
 * -# Enter an infinite loop to continuously echo received values on the USART.
 *    \snippet qs_usart_basic_use.c main_loop
 * -# Perform a blocking read of the USART, storing the received character into
 *    the previously declared temporary variable.
 *    \snippet qs_usart_basic_use.c main_read
 * -# Echo the received variable back to the USART via a blocking write.
 *    \snippet qs_usart_basic_use.c main_write
 */
